//
//  GlyphsCore.h
//  GlyphsCore
//
//  Created by Georg Seifert on 18/08/14.
//  Copyright (c) 2014 schriftgestaltung.de. All rights reserved.
//

#ifndef GlyphsCore_GlyphsCore_h
#define GlyphsCore_GlyphsCore_h

#import <Cocoa/Cocoa.h>

extern BOOL isSierra;
extern BOOL isHighSierra;
extern BOOL isMojave;
extern BOOL isCatalina;
extern BOOL isBigSur;

BOOL nilEqual(id a, id b);

#define GLYPHS3 1
#define GLYPHS_VERSION 3

#ifdef DEBUG
void inspectClassStopAt(Class inspectedClass, Class stopClass);
#endif

#import <GlyphsCore/CFOldStylePList.h>
#import <GlyphsCore/CFPropertyListWriter_vintage.h>
#import <GlyphsCore/GlyphsCore.h>
#import <GlyphsCore/GlyphsFileFormatProtocol.h>
#import <GlyphsCore/GlyphsFilterProtocol.h>
#import <GlyphsCore/GlyphsPaletteProtocol.h>
#import <GlyphsCore/GlyphsPathPlugin.h>
#import <GlyphsCore/GlyphsPluginProtocol.h>
#import <GlyphsCore/GlyphsReporterProtocol.h>
#import <GlyphsCore/GlyphsToolAuxiliaryDrawing.h>
#import <GlyphsCore/GlyphsToolbarExtensionProtocol.h>
#import <GlyphsCore/GlyphsToolDrawProtocol.h>
#import <GlyphsCore/GlyphsToolEventProtocol.h>
#import <GlyphsCore/GlyphsToolProtocol.h>
#import <GlyphsCore/GraphicsGems.h>
#import <GlyphsCore/GSAlignmentZone.h>
#import <GlyphsCore/GSAnchor.h>
#import <GlyphsCore/GSAnnotation.h>
#import <GlyphsCore/GSAppDelegateProtocol.h>
#import <GlyphsCore/GSApplicationPluginProtocol.h>
#import <GlyphsCore/GSAsyncAwait.h>
#import <GlyphsCore/GSAxis.h>
#import <GlyphsCore/GSBackgroundImage.h>
#import <GlyphsCore/GSBackgroundLayer.h>
#import <GlyphsCore/GSBase.h>
#import <GlyphsCore/GSBasePen.h>
#import <GlyphsCore/GSBezStringPen.h>
#import <GlyphsCore/GSCallbackHandler.h>
#import <GlyphsCore/GSCFIndexToCFIndexMap.h>
#import <GlyphsCore/GSClass.h>
#import <GlyphsCore/GSColorLabelViewController.h>
#import <GlyphsCore/GSComponent.h>
#import <GlyphsCore/GSContainerProtocol.h>
#import <GlyphsCore/GSContentProtocol.h>
#import <GlyphsCore/GSCustomParameter.h>
#import <GlyphsCore/GSDialogContentView.h>
#import <GlyphsCore/GSDialogController.h>
#import <GlyphsCore/GSElement.h>
#import <GlyphsCore/GSEPStoPath.h>
#import <GlyphsCore/GSExportSettingsViewController.h>
#import <GlyphsCore/GSFeature.h>
#import <GlyphsCore/GSFeatureComposer.h>
#import <GlyphsCore/GSFeatureGenerator.h>
#import <GlyphsCore/GSFeaturePrefix.h>
#import <GlyphsCore/GSFilterPlugin.h>
#import <GlyphsCore/GSFilterPropertiesController.h>
#import <GlyphsCore/GSFlattenPen.h>
#import <GlyphsCore/GSFont.h>
#import <GlyphsCore/GSFont+GenerateGlyphs.h>
#import <GlyphsCore/GSFont+SerialImport.h>
#import <GlyphsCore/GSFont+SerialSave.h>
#import <GlyphsCore/GSFontCheckerProtocol.h>
#import <GlyphsCore/GSFontInfoProperty.h>
#import <GlyphsCore/GSFontInfoValue.h>
#import <GlyphsCore/GSFontInfoValueLocalized.h>
#import <GlyphsCore/GSFontInfoValueSingle.h>
#import <GlyphsCore/GSFontMaster-Display.h>
#import <GlyphsCore/GSFontMaster.h>
#import <GlyphsCore/GSFractionalRange.h>
#import <GlyphsCore/GSGeometrieHelper.h>
#import <GlyphsCore/GSGeometrieHelper+Private.h>
#import <GlyphsCore/GSGlyph.h>
#import <GlyphsCore/GSGlyph+MetricsKeys.h>
#import <GlyphsCore/GSGlyph+TrueTypeCurves.h>
#import <GlyphsCore/GSGlyphCell.h>
#import <GlyphsCore/GSGlyphCellView.h>
#import <GlyphsCore/GSGlyphEditViewProtocol.h>
#import <GlyphsCore/GSGlyphInfo.h>
#import <GlyphsCore/GSGlyphsInfo.h>
#import <GlyphsCore/GSGlyphsInfo+InfoLoading.h>
#import <GlyphsCore/GSGlyphSortDescriptor.h>
#import <GlyphsCore/GSGlyphViewControllerProtocol.h>
#import <GlyphsCore/GSGuide.h>
#import <GlyphsCore/GSHandle.h>
#import <GlyphsCore/GSHandleCustomFilesProtocol.h>
#import <GlyphsCore/GSHint.h>
#import <GlyphsCore/GSIdentifiableParameter.h>
#import <GlyphsCore/GSIndexedLookupTable.h>
#import <GlyphsCore/GSInfoValue.h>
#import <GlyphsCore/GSInfoViewContainer.h>
#import <GlyphsCore/GSInspectorViewController.h>
#import <GlyphsCore/GSInstance-Display.h>
#import <GlyphsCore/GSInstance.h>
#import <GlyphsCore/GSInterpolationFontProxy.h>
#import <GlyphsCore/GSLayer_Drawing.h>
#import <GlyphsCore/GSLayer-Transformation.h>
#import <GlyphsCore/GSLayer.h>
#import <GlyphsCore/GSLayer+AlignComponents.h>
#import <GlyphsCore/GSLayer+Autohinting.h>
#import <GlyphsCore/GSLayer+ImportOutlines.h>
#import <GlyphsCore/GSLayer+MetricsKeysUI.h>
#import <GlyphsCore/GSLayer+PathOperations.h>
#import <GlyphsCore/GSLayer+TrueTypeExport.h>
#import <GlyphsCore/GSLayerDrawHelper.h>
#import <GlyphsCore/GSMetric.h>
#import <GlyphsCore/GSMetricValue.h>
#import <GlyphsCore/GSModalOpenPanel.h>
#import <GlyphsCore/GSModalSavePanel.h>
#import <GlyphsCore/GSNoBackgroundTextFieldCell.h>
#import <GlyphsCore/GSNode.h>
#import <GlyphsCore/GSNotifyingDictionary.h>
#import <GlyphsCore/GSOutlineImporter.h>
#import <GlyphsCore/GSPaletteView.h>
#import <GlyphsCore/GSPanelView.h>
#import <GlyphsCore/GSPanelViewController.h>
#import <GlyphsCore/GSPartProperty.h>
#import <GlyphsCore/GSPath.h>
#import <GlyphsCore/GSPath+PenDrawing.h>
#import <GlyphsCore/GSPath+Primitives.h>
#import <GlyphsCore/GSPathOperator.h>
#import <GlyphsCore/GSPathPen.h>
#import <GlyphsCore/GSPathSegment.h>
#import <GlyphsCore/GSPDFParser.h>
#import <GlyphsCore/GSPenProtocol.h>
#import <GlyphsCore/GSPieceInterpolation.h>
#import <GlyphsCore/GSProgressWindowController.h>
#import <GlyphsCore/GSProxyShapes.h>
#import <GlyphsCore/GSReadFromCharstring.h>
#import <GlyphsCore/GSSaveBezierPath.h>
#import <GlyphsCore/GSSegmentPen.h>
#import <GlyphsCore/GSSelectableElementProtocol.h>
#import <GlyphsCore/GSSelectGlyphsDialogController.h>
#import <GlyphsCore/GSShape.h>
#import <GlyphsCore/GSShortcutCommandProtocol.h>
#import <GlyphsCore/GSShortcutItem.h>
#import <GlyphsCore/GSSidebarItem.h>
#import <GlyphsCore/GSSnapper.h>
#import <GlyphsCore/GSSteppingTextField.h>
#import <GlyphsCore/GSSubstitution.h>
#import <GlyphsCore/GSSVGPen.h>
#import <GlyphsCore/GSSVGtoPath.h>
#import <GlyphsCore/GSTextInputFormatter.h>
#import <GlyphsCore/GSToolGroup.h>
#import <GlyphsCore/GSToolPlugin.h>
#import <GlyphsCore/GSToolSelect.h>
#import <GlyphsCore/GSTransformableElement.h>
#import <GlyphsCore/GSTransformGrid.h>
#import <GlyphsCore/GSTTStem.h>
#import <GlyphsCore/GSUndoManager.h>
#import <GlyphsCore/GSUserDataProtocol.h>
#import <GlyphsCore/GSWindowControllerProtocol.h>
#import <GlyphsCore/InspectorViewAnchorController.h>
#import <GlyphsCore/InspectorViewBackgroundImageController.h>
#import <GlyphsCore/InspectorViewComponentController.h>
#import <GlyphsCore/InspectorViewGlyphController.h>
#import <GlyphsCore/InspectorViewGlyphTextController.h>
#import <GlyphsCore/InspectorViewGlyphVerticalController.h>
#import <GlyphsCore/InspectorViewGuideController.h>
#import <GlyphsCore/InspectorViewHintController.h>
#import <GlyphsCore/InspectorViewIconController.h>
#import <GlyphsCore/InspectorViewKerningController.h>
#import <GlyphsCore/InspectorViewNodeController.h>
#import <GlyphsCore/InspectorViewNodesController.h>
#import <GlyphsCore/InspectorViewOffNodeController.h>
#import <GlyphsCore/LBSVGToBezierPath.h>
#import <GlyphsCore/MGOrderedDictionary.h>
#import <GlyphsCore/NSAffineTransform_Shearing.h>
#import <GlyphsCore/NSArrayHelpers.h>
#import <GlyphsCore/NSBezierPath-OAExtensions.h>
#import <GlyphsCore/NSBezierPath+Additons.h>
#import <GlyphsCore/NSBezierPath+GSPenSupport.h>
#import <GlyphsCore/NSBezierPath+transformers.h>
#import <GlyphsCore/NSControl+LocalizedFloatValue.h>
#import <GlyphsCore/NSData_Conversion.h>
#import <GlyphsCore/NSDictionaryHelpers.h>
#import <GlyphsCore/NSError-Convenient.h>
#import <GlyphsCore/NSImage+Addons.h>
#import <GlyphsCore/NSImage+QuickLook.h>
#import <GlyphsCore/NSMenuHelper.h>
#import <GlyphsCore/NSNumber+Helper.h>
#import <GlyphsCore/NSObject+PerformCoalescing.h>
#import <GlyphsCore/NSPredicateEditorRowTemplate+convenient.h>
#import <GlyphsCore/NSString+BadgeDrawing.h>
#import <GlyphsCore/NSString+SymlinksAndAliases.h>
#import <GlyphsCore/NSStringHelpers.h>

#endif
